/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;

public abstract class StorageWrapper
implements IStorageWrapper {
    private static final String MAIN_COLOR_TAG = "mainColor";
    private static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String UUID_TAG = "uuid";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    public static final String CONTENTS_TAG = "contents";
    private final Supplier<Runnable> getSaveHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    private CompoundTag contentsNbt = new CompoundTag();
    private CompoundTag settingsNbt = new CompoundTag();
    private final SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private CompoundTag renderInfoNbt = new CompoundTag();
    @Nullable
    protected UUID contentsUuid = null;
    private int openTabId = -1;
    protected int numberOfInventorySlots = 0;
    protected int numberOfUpgradeSlots = -1;
    private SortBy sortBy = SortBy.NAME;
    private int columnsTaken = 0;
    private int mainColor = -1;
    private int accentColor = -1;

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, final Runnable onSerializeRenderInfo, Runnable markContentsDirty) {
        this.getSaveHandler = getSaveHandler;
        this.renderInfo = new RenderInfo(getSaveHandler){

            protected void serializeRenderInfo(CompoundTag renderInfo) {
                StorageWrapper.this.renderInfoNbt = renderInfo;
                onSerializeRenderInfo.run();
            }

            protected Optional<CompoundTag> getRenderInfoTag() {
                return Optional.of(StorageWrapper.this.renderInfoNbt);
            }
        };
        this.settingsHandler = new StorageSettingsHandler(this.settingsNbt, markContentsDirty, () -> this.inventoryHandler, () -> this.renderInfo);
    }

    public void setContentsUuid(@Nullable UUID contentsUuid) {
        this.contentsUuid = contentsUuid;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
            }){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.m_41619_() || "sophisticatedstorage".equals(stack.m_41720_().getRegistryName().m_135827_()) || stack.m_204117_(ModItems.STORAGE_UPGRADE_TAG));
                }

                public void refreshUpgradeWrappers() {
                    super.refreshUpgradeWrappers();
                    StorageWrapper.this.onUpgradeRefresh();
                }
            };
        }
        return this.upgradeHandler;
    }

    protected abstract void onUpgradeRefresh();

    public CompoundTag save(CompoundTag tag) {
        this.saveContents(tag);
        this.saveData(tag);
        return tag;
    }

    private void saveContents(CompoundTag tag) {
        tag.m_128365_(CONTENTS_TAG, (Tag)this.getContentsNbt().m_6426_());
    }

    CompoundTag saveData(CompoundTag tag) {
        if (!this.settingsNbt.m_128456_()) {
            tag.m_128365_("settings", (Tag)this.settingsNbt);
        }
        if (!this.renderInfoNbt.m_128456_()) {
            tag.m_128365_("renderInfo", (Tag)this.renderInfoNbt);
        }
        if (this.contentsUuid != null) {
            tag.m_128365_(UUID_TAG, (Tag)NbtUtils.m_129226_((UUID)this.contentsUuid));
        }
        if (this.openTabId >= 0) {
            tag.m_128405_(OPEN_TAB_ID_TAG, this.openTabId);
        }
        tag.m_128359_("sortBy", this.sortBy.m_7912_());
        if (this.columnsTaken > 0) {
            tag.m_128405_("columnsTaken", this.columnsTaken);
        }
        if (this.numberOfInventorySlots > 0) {
            tag.m_128405_("numberOfInventorySlots", this.numberOfInventorySlots);
        }
        if (this.numberOfUpgradeSlots > -1) {
            tag.m_128405_("numberOfUpgradeSlots", this.numberOfUpgradeSlots);
        }
        if (this.mainColor != 0) {
            tag.m_128405_(MAIN_COLOR_TAG, this.mainColor);
        }
        if (this.accentColor != 0) {
            tag.m_128405_(ACCENT_COLOR_TAG, this.accentColor);
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        this.loadContents(tag);
        this.loadData(tag);
    }

    private void loadData(CompoundTag tag) {
        this.settingsNbt = tag.m_128469_("settings");
        this.settingsHandler.reloadFrom(this.settingsNbt);
        this.renderInfoNbt = tag.m_128469_("renderInfo");
        this.renderInfo.deserializeFrom(this.renderInfoNbt);
        this.contentsUuid = NBTHelper.getTagValue((CompoundTag)tag, (String)UUID_TAG, CompoundTag::m_128423_).map(NbtUtils::m_129233_).orElse(null);
        this.openTabId = NBTHelper.getInt((CompoundTag)tag, (String)OPEN_TAB_ID_TAG).orElse(-1);
        this.sortBy = NBTHelper.getString((CompoundTag)tag, (String)"sortBy").map(SortBy::fromName).orElse(SortBy.NAME);
        this.columnsTaken = NBTHelper.getInt((CompoundTag)tag, (String)"columnsTaken").orElse(0);
        this.loadSlotNumbers(tag);
        this.mainColor = NBTHelper.getInt((CompoundTag)tag, (String)MAIN_COLOR_TAG).orElse(-1);
        this.accentColor = NBTHelper.getInt((CompoundTag)tag, (String)ACCENT_COLOR_TAG).orElse(-1);
    }

    protected void loadSlotNumbers(CompoundTag tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((CompoundTag)tag, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((CompoundTag)tag, (String)"numberOfUpgradeSlots").orElse(-1);
    }

    private void loadContents(CompoundTag tag) {
        if (tag.m_128441_(CONTENTS_TAG)) {
            this.contentsNbt = tag.m_128469_(CONTENTS_TAG);
            this.onContentsNbtUpdated();
        }
    }

    public void setSaveHandler(Runnable saveHandler) {
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.COMMON.stackUpgrade){

            protected boolean isAllowed(ItemStack stack) {
                return StorageWrapper.this.isAllowedInStorage(stack);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
    }

    protected CompoundTag getContentsNbt() {
        return this.contentsNbt;
    }

    private int getNumberOfInventorySlots() {
        if (this.numberOfInventorySlots > 0) {
            return this.numberOfInventorySlots;
        }
        this.numberOfInventorySlots = this.getDefaultNumberOfInventorySlots();
        this.save();
        return this.numberOfInventorySlots;
    }

    protected void save() {
        this.getSaveHandler.get().run();
    }

    public abstract int getDefaultNumberOfInventorySlots();

    protected abstract boolean isAllowedInStorage(ItemStack var1);

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    private int getNumberOfUpgradeSlots() {
        if (this.numberOfUpgradeSlots > -1) {
            return this.numberOfUpgradeSlots;
        }
        this.numberOfUpgradeSlots = this.getDefaultNumberOfUpgradeSlots();
        this.save();
        return this.numberOfUpgradeSlots;
    }

    public abstract int getDefaultNumberOfUpgradeSlots();

    public int getMainColor() {
        return this.mainColor;
    }

    public boolean hasMainColor() {
        return this.mainColor > -1;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public boolean hasAccentColor() {
        return this.accentColor > -1;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
    }

    public Optional<Integer> getOpenTabId() {
        return this.openTabId >= 0 ? Optional.of(this.openTabId) : Optional.empty();
    }

    public void setOpenTabId(int openTabId) {
        this.openTabId = openTabId;
        this.save();
    }

    public void removeOpenTabId() {
        this.openTabId = -1;
        this.save();
    }

    public void setColors(int mainColor, int accentColor) {
        this.mainColor = mainColor;
        this.accentColor = accentColor;
        this.save();
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
        this.save();
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(Player playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        this.columnsTaken = columnsTaken;
        this.save();
    }

    public int getColumnsTaken() {
        return this.columnsTaken;
    }

    public void increaseSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        if (additionalInventorySlots > 0) {
            this.numberOfInventorySlots += additionalInventorySlots;
            this.getInventoryHandler().changeSlots(additionalInventorySlots);
        }
        if (additionalUpgradeSlots > 0) {
            this.numberOfUpgradeSlots += additionalUpgradeSlots;
            this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
        }
    }
}

